<?php
/* --------------------------------------------------------------
 LineBreak.php 2019-12-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Types;

use Gambio\Core\Configuration\Models\Read\Collections\Options;
use Gambio\Core\Configuration\Models\Read\Option;
use Gambio\Core\Configuration\Repositories\Components\OptionsResolver;

/**
 * Class LineBreak
 * @package Gambio\Core\Configuration\Types
 */
class LineBreak implements ConfigurationType
{
    /**
     * @inheritDoc
     */
    public function toOptions(OptionsResolver $resolver, string $value = null): ?Options
    {
        $options = [
            Option::create('LF', $resolver->getText('GM_CFG_LF', 'gm_general')),
            Option::create('CRLF', $resolver->getText('GM_CFG_CRLF', 'gm_general')),
        ];
        
        return Options::create(...$options);
    }
    
    
    /**
     * @inheritDoc
     */
    public function inputType(): string
    {
        return 'dropdown';
    }
}